/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.debug.core;

import com.aptana.debug.core.FilterProxyInputStream;
import com.aptana.debug.core.IProcessOutputFilter;
import com.aptana.debug.core.ProxyProcess;
import java.io.InputStream;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.RuntimeProcess;

public class FilterConsoleProcess
extends RuntimeProcess {
    private IProcessOutputFilter processOutputFilter;
    private ProxyProcess proxyProcess;

    public FilterConsoleProcess(ILaunch launch, Process process, String name, Map attributes) {
        super(launch, process, name, attributes);
    }

    public void setProcessOutputFilter(IProcessOutputFilter processOutputFilter) {
        this.processOutputFilter = processOutputFilter;
        if (this.proxyProcess != null) {
            ((FilterProxyInputStream)this.proxyProcess.getInputStream()).setProcessOutputFilter(processOutputFilter);
            ((FilterProxyInputStream)this.proxyProcess.getErrorStream()).setProcessOutputFilter(processOutputFilter);
        }
    }

    protected Process getSystemProcess() {
        if (this.proxyProcess == null) {
            this.proxyProcess = new ProxyProcess(super.getSystemProcess()){

                protected InputStream createInputStream(InputStream in) {
                    String encoding = FilterConsoleProcess.this.getLaunch().getAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_ENCODING");
                    return new FilterProxyInputStream(in, encoding, FilterConsoleProcess.this.processOutputFilter);
                }
            };
        }
        return this.proxyProcess;
    }
}

